'----------------------------------------------------------------------------
'
' Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
'
' Use, modification and distribution are subject to the Boost Software
' License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
'
'----------------------------------------------------------------------------

Imports SIMCAQLib

Public Class Form1
   Private ezQ As New SQPVBSample.EzQ()

   Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
      If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
         Try
            If (ezQ.OpenProject(OpenFileDialog1.FileName, Nothing) = False) Then
               Throw New System.Exception(ezQ.LastErrorMessage)
            End If
            ezQ.SelectModel(1)

            ' Create a fake prediction set
            Dim lPredictions As Long = DirectCast(DirectCast(ezQ.Model.PreparePrediction(), PreparePrediction).GetVariablesForPrediction(), VariableVector).GetSize()
            Dim predSet As Single() = New Single(lPredictions - 1) {}
            For i As Integer = 0 To predSet.Length - 1
               predSet(i) = i
            Next
            ezQ.Predict(predSet, 1, predSet.Length, Nothing, 0, 0)

            ' Output the result
            Dim result As VectorData = ezQ.GetDModXPS()
            lblDModX.Text = [String].Format("{0}", DirectCast(result.GetDataMatrix(), FloatMatrix).GetData(1, 1))
            result = ezQ.GetT2RangePS()
            lblHotellingsT2.Text = [String].Format("{0}", DirectCast(result.GetDataMatrix(), FloatMatrix).GetData(1, 1))

            ezQ.CloseProject()
         Catch ex As System.Exception
            MessageBox.Show([String].Format("An error occured while processing the project:" &
                                            Environment.NewLine & Environment.NewLine &
                                            "{0}", ex.Message), Text)
            lblDModX.Text = "N/A"
            lblHotellingsT2.Text = "N/A"
            ezQ.CloseProject()
         End Try
      End If
   End Sub

   Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
      Close()
   End Sub
End Class
